﻿using UnityEngine;

public class CharacterController : MonoBehaviour
{
    public float forwardVelocity = 7;
    public float backwardsVelocity = 3;
    public float horizontalRotationVelocity = 50;

    public float minIdleVariationTime = 6;
    public float maxIdleVariationTime = 10;
    private float remainingVariationTime;
    
    [Header("Prefab References")]
    public Transform cameraTransform;
    public Animator animator;
    public Rigidbody characterRigidbody;

    private void Update()
    {
        if (!TranslateCharacter())
            TriggerIdleVariation();
    }

    private bool TranslateCharacter()
    {
        var horizontal = Input.GetAxis("Horizontal");
        var vertical = Input.GetAxis("Vertical");

        animator.SetFloat("SideVelocity", horizontal);
        animator.SetFloat("ForwardVelocity", vertical);

        var moving = horizontal != 0 || vertical != 0;
        animator.SetBool("Moving", moving);

        if (!moving)
            return false;

        var velocity = vertical > 0 ? forwardVelocity : backwardsVelocity;


        var rotateDirection = vertical >= 0 ? 1 : -1;
        transform.Rotate(rotateDirection * horizontal * Vector3.up * Time.deltaTime * horizontalRotationVelocity);
        characterRigidbody.rotation = transform.rotation;
        
        var deltaPosition = transform.forward * vertical * velocity * Time.deltaTime;
        characterRigidbody.MovePosition(transform.position + deltaPosition);

        return true;
    }

    private void TriggerIdleVariation()
    {
        remainingVariationTime -= Time.deltaTime;

        if (!(remainingVariationTime <= 0))
            return;
        
        remainingVariationTime = Random.Range(minIdleVariationTime, maxIdleVariationTime);
            
        animator.SetInteger("VariationNumber", Random.Range(0, 2));
        animator.SetTrigger("PlayVariation");
    }
}
